USE [EleriumClean]
GO

/****** Object:  Table [dbo].[RewardSplit]    Script Date: 10/3/2013 8:13:28 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[RewardSplit](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[ProjectID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Islibrary] [bit] NOT NULL,
	[LibraryPopularity] [decimal](19, 9) NOT NULL,
	[Percentage] [decimal](3, 2) NOT NULL,
	[DailyBudgetDate] [date] NOT NULL,
 CONSTRAINT [PK_RewardSplit] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [dbo].[RewardSplit] ADD  CONSTRAINT [DF_RewardSplit_Islibrary]  DEFAULT ((0)) FOR [Islibrary]
GO

ALTER TABLE [dbo].[RewardSplit] ADD  CONSTRAINT [DF_RewardSplit_LibraryPopularity]  DEFAULT ((0.0)) FOR [LibraryPopularity]
GO

ALTER TABLE [dbo].[RewardSplit]  WITH CHECK ADD  CONSTRAINT [FK_RewardSplit_User] FOREIGN KEY([UserID])
REFERENCES [dbo].[User] ([ID])
GO

ALTER TABLE [dbo].[RewardSplit] CHECK CONSTRAINT [FK_RewardSplit_User]
GO


